<?php

namespace VM\ApiBundle\Repository;

use Doctrine\ORM\EntityRepository;
use VM\ApiBundle\Entity\Company;

/**
 * BankServiceRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class BankServiceRepository extends EntityRepository
{
    public function getCompanyBankServiceOptions($companyId)
    {
        $QueryBuilder = $this->createQueryBuilder('bs')
            ->leftJoin('bs.types', 'options')
            ->leftJoin('options.companyBankServiceOptions', 'cbso')
            ->select('bs', 'options', 'cbso')
        ;

        $where = $QueryBuilder->expr()->orX(
            $QueryBuilder->expr()->eq('cbso.companyId', $companyId),
            $QueryBuilder->expr()->isNull('cbso.companyId')
        );

        $QueryBuilder->andWhere($where);

        return $QueryBuilder->getQuery()->getResult();
    }
}